#ifndef __VstIncludes__
#define __VstIncludes__

/**
 * @file EVst.h
 * @brief Single include for the Exponent VST namespace
 *
 * @date 23/08/2004
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.\n
 * Certain sections of this code may come from other sources. They are credited where applicable.\n
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 * Please note that VST is copyright Steinberg Media GmBh. No challenge is made to any of their trademarks
 * To use this file, you require a copy of the VST SDK, available from www.steinberg.net for free
 *
 * $Id: EVST.h,v 1.6 2007/02/08 21:08:23 paul Exp $
 */

/**
 * @namespace Exponent::Vst
 * @brief VST namespace
 */

#include "CHostCanDo.hpp"
#include "CVst.hpp"
#include "CVstEffect.hpp"
#include "CVstExceptionHandler.hpp"
#include "CVstMidiEventList.hpp"
#include "CVstTempo.hpp"
#include "CVstWindow.hpp"
#include "SVstProcessInformation.hpp"

//	===========================================================================
#ifndef EXPONENT_COMPACT_BUILD
	using namespace Exponent::Vst;
#endif


#endif	// End of Vst.h